// ustawienie rozmiaru świata gry, zmienne te są kilka razy używane
var width = 480;
var height = 320;

// utworzenie i zaincjalizowanie świata gry
var game = new Phaser.Game(width, height, Phaser.AUTO, null, {preload: preload, create: create, update: update});

// incjalizacja zmiennych
// zmienna symbolizuje gracza
var gracz;

// zmienna symbolizuje spadające jabłko
var jablko;

// szybkość poruszania graczem
var szybkosc = 275;

// zmienna symbolizuje wyświetlaną informację, komunikat, liczbę punktów
var informacja;

// start=0 oznacza, że gra nie wystartowała, poźniej start=1
var start=0;

// początkowa liczba punktów
var punkty = 0;


// -------------------------------------------------------
// -------------------------------------------------------

function preload() {
	// ustawienie koloru tła - standardowo jest czarne
	game.stage.backgroundColor = '#fff';
	// załadowanie obrazków, przypisanie im nazw
	game.load.image('gracz', 'asset/koszyk.png');
	game.load.image('jedzenie', 'asset/jablko.png');
	game.load.image('trawa', 'asset/trawa.png');

}

// -------------------------------------------------------
// -------------------------------------------------------

function create() {	
	// włączenie fizyki ARCADE dla całego świata
	game.physics.startSystem(Phaser.Physics.ARCADE);
	// zainicjuj strzałki klawiatury do kontroli gier
	cursors = game.input.keyboard.createCursorKeys();
	// dodanie sprita gracza
	gracz = game.add.sprite(160, 240, 'gracz');
	// włączenie wizyki dla gracza - fizyka - ARCADE
	game.physics.enable(gracz, Phaser.Physics.ARCADE);
	// wykrywane są "kolizje gracza z granicami świata"
	gracz.body.collideWorldBounds = true;
	// dołożenie informacji - komunikat startowy - współrzędne x,y (left, top)
	informacja = game.add.text(80, 50, "Naciśnij strzałkę w górę aby rozpocząć !", { font: "18px Arial" } );
	// definicja trawy jest potrzebna żeby wykryć
	// kiedy jabłko spadnie
	// jako "początek" umieszczenia są podane współrzędne 
	trawa = game.add.sprite(0, 310, 'trawa');
	game.physics.enable(trawa, Phaser.Physics.ARCADE);

}

// -------------------------------------------------------
// -------------------------------------------------------

function update() {

	
	// jeśli strzałka naciśnięta i jest to "pierwszy raz", to zaczynamy
	if ((cursors.up.isDown)&&(start==0))
    {
        // usunięcie informacji - Naciśnij strzałkę w górę aby rozpocząć ! - gra się zaczyna
		informacja.kill();
		// gra się zaczyna - ustawiamy zmienną start na 1
		start=1;
		// uruchomienie funkcji noweJablko(), która generuje spadające jabłka
		noweJablko();
		
		//NOWE
		// wstawienie aktulanej liczby punktów do pola punktów czyli 0
		informacja = game.add.text(430, 280, punkty);
		
	}


	// definicja reakcji na strzełki (klawiaturę) lewo i prawo
	if (cursors.left.isDown) {
		// przesywamy gracza w  lewo
		// własciwość velocity oznacza lub tempo zmiany prędkości ciała - mierzona jest w pikselach na sekundę
		// wartość ujemna czyli w lewo, bo w prawo współrzędna x rośnie
		gracz.body.velocity.x = -szybkosc;
	}
	else if (cursors.right.isDown) {
		// przesywamy gracza w  prawoa
		gracz.body.velocity.x = szybkosc;
	}
	else {
		// zatrzymanie gracza jak nie naciska <- lub ->
		gracz.body.velocity.x = 0;
	}

	//definicja co się stanie gdy jabłko spotka się z trawa
	// wywołana jest funkcja koniecGry
	game.physics.arcade.overlap(trawa, jablko, koniecGry);

	// NOWE
	//definicja co się stanie gdy jabłko spotka się z koszykiem
	// wywołana jest funkcja wKoszyku
	game.physics.arcade.overlap(gracz, jablko, wKoszyku);

	
}


//funkcja generuje spadające jabłko
function noweJablko() {
	//utworzenie nowego sprite w wylosowanych współrzędnych
	jablko = game.add.sprite(game.rnd.between(40, 440), 0, 'jedzenie');
	//włączenie fizyki dla typu ARCADE dla obiektu jabłko
	game.physics.arcade.enable(jablko);
	//włączenie grawitacj dla obiektu jabłko
	//wartość jest przypadkowa
	jablko.body.gravity.y = game.rnd.between(200, 900);
}

// NOWE
//funkcja koniecGry wywoływana na końcu gry ;-)
function koniecGry(gracz, food) {
	//zlikwiduj obiekt jabłko
	jablko.kill();
	// zlikwiduj informację o punktach
	informacja.kill();
	// utwórz nową informację - o punktach i, że koniec gry
	informacja = game.add.text(10, 50, punkty+" pkt. Koniec gry! Naciśnij strzałkę w górę aby rozpocząć!", { font: "18px Arial" } );
	// ustawienie zmiennych początkowych na zero bo jeśli gracz
	// naciśnie spację to wszystko zaczyna się od nowa
	start=0;
	punkty=0;
}

// NOWE
//funkcja wKoszyku wywoływana gdy jabłko wpadnie do koszyka
function wKoszyku(gracz, food) {
	//zlikwiduj obiekt jabłko - wpadło do koszyka
	jablko.kill();
	//zwiększ liczbę punktów
	punkty++;
	informacja.text = punkty;
	//utwórz nowy obiekt jabłko
	noweJablko()
}