// ustawienie rozmiaru świata gry, zmienne te są kilka razy używane
var width = 480;
var height = 320;

// utworzenie i zaincjalizowanie świata gry
var game = new Phaser.Game(width, height, Phaser.AUTO, null, {preload: preload, create: create, update: update});

// incjalizacja zmiennych
// zmienna symbolizuje gracza
var gracz;

// szybkość poruszania graczem
var szybkosc = 275;

// NOWE
// zmienna symbolizuje spadające jabłko
var jablko;


// -------------------------------------------------------
// -------------------------------------------------------

function preload() {
	// ustawienie koloru tła - standardowo jest czarne
	game.stage.backgroundColor = '#fff';
	// załadowanie obrazków, przypisanie im nazw
	game.load.image('gracz', 'asset/koszyk.png');
	// NOWE !!!
	game.load.image('jedzenie', 'asset/jablko.png');

}

// -------------------------------------------------------
// -------------------------------------------------------

function create() {	
	// włączenie fizyki ARCADE dla całego świata
	game.physics.startSystem(Phaser.Physics.ARCADE);
	// zainicjuj strzałki klawiatury do kontroli gier
	cursors = game.input.keyboard.createCursorKeys();
	// dodanie sprita gracza
	gracz = game.add.sprite(160, 240, 'gracz');
	// włączenie wizyki dla gracza - fizyka - ARCADE
	game.physics.enable(gracz, Phaser.Physics.ARCADE);
	// wykrywane są "kolizje gracza z granicami świata"
	gracz.body.collideWorldBounds = true;
	
}

// -------------------------------------------------------
// -------------------------------------------------------

function update() {

	// NOWE  uruchomienie funkcji noweJablko(), która generuje spadające jabłka
	noweJablko();


	// definicja reakcji na strzełki (klawiaturę) lewo i prawo
	if (cursors.left.isDown) {
		// przesywamy gracza w  lewo
		// własciwość velocity oznacza lub tempo zmiany prędkości ciała - mierzona jest w pikselach na sekundę
		// wartość ujemna czyli w lewo, bo w prawo współrzędna x rośnie
		gracz.body.velocity.x = -szybkosc;
	}
	else if (cursors.right.isDown) {
		// przesywamy gracza w  prawoa
		gracz.body.velocity.x = szybkosc;
	}
	else {
		// zatrzymanie gracza jak nie naciska <- lub ->
		gracz.body.velocity.x = 0;
	}
	
}

// NOWE
//funkcja generuje spadające jabłko
function noweJablko() {
	//utworzenie nowego sprite w wylosowanych współrzędnych
	jablko = game.add.sprite(game.rnd.between(40, 440), 0, 'jedzenie');
	//włączenie fizyki dla typu ARCADE dla obiektu jabłko
	game.physics.arcade.enable(jablko);
	//włączenie grawitacj dla obiektu jabłko
	//wartość jest przypadkowa
	jablko.body.gravity.y = game.rnd.between(200, 900);
}