// ustawienie rozmiaru świata gry, zmienne te są kilka razy używane
var width = 480;
var height = 320;

// utworzenie i zaincjalizowanie świata gry
var game = new Phaser.Game(width, height, Phaser.AUTO, null, {preload: preload, create: create, update: update});

// incjalizacja zmiennych
// zmienna symbolizuje gracza
var gracz;


// szybkość poruszania graczem
var szybkosc = 275;


// -------------------------------------------------------
// -------------------------------------------------------

function preload() {
	// ustawienie koloru tła - standardowo jest czarne
	game.stage.backgroundColor = '#fff';
	// załadowanie obrazków, przypisanie im nazw
	game.load.image('gracz', 'asset/koszyk.png');

}

// -------------------------------------------------------
// -------------------------------------------------------

function create() {	
	// włączenie fizyki ARCADE dla całego świata
	game.physics.startSystem(Phaser.Physics.ARCADE);
	// zainicjuj strzałki klawiatury do kontroli gier
	cursors = game.input.keyboard.createCursorKeys();
	// dodanie sprita gracza
	gracz = game.add.sprite(160, 240, 'gracz');
	// włączenie wizyki dla gracza - fizyka - ARCADE
	game.physics.enable(gracz, Phaser.Physics.ARCADE);
	// wykrywane są "kolizje gracza z granicami świata"
	gracz.body.collideWorldBounds = true;
	
}

// -------------------------------------------------------
// -------------------------------------------------------

function update() {

	// definicja reakcji na strzełki (klawiaturę) lewo i prawo
	if (cursors.left.isDown) {
		// przesywamy gracza w  lewo
		// własciwość velocity oznacza lub tempo zmiany prędkości ciała - mierzona jest w pikselach na sekundę
		// wartość ujemna czyli w lewo, bo w prawo współrzędna x rośnie
		gracz.body.velocity.x = -szybkosc;
	}
	else if (cursors.right.isDown) {
		// przesywamy gracza w  prawoa
		gracz.body.velocity.x = szybkosc;
	}
	else {
		// zatrzymanie gracza jak nie naciska <- lub ->
		gracz.body.velocity.x = 0;
	}
	
}

